
* WORKS WITH PROMISES.SAV

GET FILE='E:\DEMO REGRESSION DATA\PROMISES.SAV'.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN
  /DEPENDENT kept
  /METHOD=ENTER made.

*METHOD 1:

igraph
 /x1 = var(made)
 /y = var(kept)
 /fitline method = regression linear line = total 
 /scatter.

*METHOD 2:

GRAPH
  /SCATTERPLOT(BIVAR)=kept WITH made
  /MISSING=LISTWISE .

To add the fit line, you need to open the graph editor (by double-clicking on the graph), 
and then select the Elements pull-down menu at the top, and then select Fit Line at Total.

METHOD 3: SPSS VERSION 14 AND ABOVE:

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=read[LEVEL=SCALE] write
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
 SOURCE: s=userSource(id("graphdataset"))
 DATA: read=col(source(s), name("made"))
 DATA: write=col(source(s), name("kept"))
 GUIDE: axis(dim(1), label("Promises Made"))
 GUIDE: axis(dim(2), label("Promises Kept"))
 ELEMENT: point(position(made*kept))
END GPL.

To add the fit line, you need to open the graph editor (by double-clicking on the graph), and then select the Elements 
pull-down menu at the top, and then select Fit Line at Total.


* with promises data saving standardized residuals

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN
  /DEPENDENT made
  /METHOD=ENTER kept
  /SAVE ZRESID (ZRES) PRED (PRE).

GRAPH
  /SCATTERPLOT(BIVAR)=ZRES WITH PRE
  /MISSING=LISTWISE .

* suicides.sav BACKWARD using F ratio (compare to AIC stepwise in R)
* Using statistical significance INCOME not important in predicting suicide but has good effect size of 7% R-squared

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT suicide
  /METHOD=BACKWARD prestige income.
